/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StackListItem
implements IStackList<ItemStack> {
    private final Map<ItemStackWrapper, StackListEntry<ItemStack>> stacks = new ConcurrentHashMap<ItemStackWrapper, StackListEntry<ItemStack>>();
    private final Multimap<Item, ItemStackWrapper> stacksByItem = HashMultimap.create();
    private final Map<UUID, StackListEntry<ItemStack>> index = new HashMap<UUID, StackListEntry<ItemStack>>();
    private long stored;

    @Override
    public StackListResult<ItemStack> add(@Nonnull ItemStack stack, long size) {
        if (stack.func_190926_b() || size <= 0L) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        StackListEntry<ItemStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            entry.grow(size);
            this.stored += size;
            return new StackListResult<ItemStack>(entry.getStack().func_77946_l(), entry.getId(), size);
        }
        wrapper.setStack(stack.func_77946_l());
        StackListEntry<ItemStack> newEntry = new StackListEntry<ItemStack>(wrapper.itemStack, size);
        this.stacks.put(wrapper, newEntry);
        this.stacksByItem.put((Object)stack.func_77973_b(), (Object)wrapper);
        this.index.put(newEntry.getId(), newEntry);
        this.stored += size;
        return new StackListResult<ItemStack>(newEntry.getStack().func_77946_l(), newEntry.getId(), size);
    }

    @Override
    public StackListResult<ItemStack> add(@Nonnull ItemStack stack) {
        return this.add(stack, (long)stack.func_190916_E());
    }

    @Override
    public StackListResult<ItemStack> remove(@Nonnull ItemStack stack, long size) {
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        StackListEntry<ItemStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            if (entry.getCount() - size <= 0L) {
                this.stacks.remove(wrapper);
                this.stacksByItem.remove((Object)stack.func_77973_b(), (Object)wrapper);
                this.index.remove(entry.getId());
                this.stored -= entry.getCount();
                return new StackListResult<ItemStack>(stack.func_77946_l(), entry.getId(), -entry.getCount());
            }
            entry.shrink(size);
            this.stored -= size;
            return new StackListResult<ItemStack>(stack.func_77946_l(), entry.getId(), -size);
        }
        return null;
    }

    @Override
    public StackListResult<ItemStack> remove(@Nonnull ItemStack stack) {
        return this.remove(stack, (long)stack.func_190916_E());
    }

    @Override
    @Nullable
    public StackListEntry<ItemStack> getEntry(@Nonnull ItemStack stack, int flags) {
        if ((flags & 2) == 2 && (flags & 1) == 1 && (flags & 8) != 8) {
            StackListEntry<ItemStack> entry = this.stacks.get(new ItemStackWrapper(stack));
            if (entry == null) {
                return null;
            }
            return entry.asUnmodifiable();
        }
        for (ItemStackWrapper key : this.stacksByItem.get((Object)stack.func_77973_b())) {
            StackListEntry<ItemStack> entry = this.stacks.get(key);
            if (!API.instance().getComparer().isEqual(entry.getStack(), stack, flags)) continue;
            return entry.asUnmodifiable();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        StackListEntry<ItemStack> entry = this.getEntry(stack, flags);
        if (entry == null) {
            return null;
        }
        ItemStack copy = entry.getStack().func_77946_l();
        copy.func_190920_e((int)Math.min(entry.getCount(), Integer.MAX_VALUE));
        return copy;
    }

    @Override
    @Nullable
    public StackListEntry<ItemStack> get(UUID id) {
        StackListEntry<ItemStack> entry = this.index.get(id);
        if (entry == null) {
            return null;
        }
        return entry.asUnmodifiable();
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.stacksByItem.clear();
        this.index.clear();
        this.stored = 0L;
    }

    @Override
    public void clearCounts() {
        for (StackListEntry<ItemStack> entry : this.stacks.values()) {
            entry.setCount(0L);
        }
        this.stored = 0L;
    }

    @Override
    public void clearEmpty() {
        Iterator<Map.Entry<ItemStackWrapper, StackListEntry<ItemStack>>> iterator = this.stacks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemStackWrapper, StackListEntry<ItemStack>> entry = iterator.next();
            StackListEntry<ItemStack> stackListEntry = entry.getValue();
            if (stackListEntry.getCount() >= 1L) continue;
            this.stacksByItem.remove((Object)stackListEntry.getStack().func_77973_b(), (Object)entry.getKey());
            this.index.remove(stackListEntry.getId());
            iterator.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<ItemStack>> getStacks() {
        return Collections.unmodifiableCollection(this.stacks.values());
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> copy() {
        StackListItem list = new StackListItem();
        for (Map.Entry<ItemStackWrapper, StackListEntry<ItemStack>> entry : this.stacks.entrySet()) {
            ItemStack newStack = entry.getValue().getStack().func_77946_l();
            StackListEntry<ItemStack> newEntry = new StackListEntry<ItemStack>(entry.getValue().getId(), newStack, entry.getValue().getCount());
            list.stacks.put(new ItemStackWrapper(newStack), newEntry);
            list.stacksByItem.put((Object)newStack.func_77973_b(), (Object)new ItemStackWrapper(newStack));
            list.index.put(entry.getValue().getId(), newEntry);
            list.stored += newEntry.getCount();
        }
        return list;
    }

    public static final class ItemStackWrapper {
        private final int hashCode;
        private ItemStack itemStack;

        public ItemStackWrapper(ItemStack template) {
            this.itemStack = template;
            boolean isEmpty = template.func_190926_b();
            Item item = template.func_77973_b();
            NBTTagCompound originalNbt = template.func_77978_p();
            NBTTagCompound nbt = originalNbt == null || originalNbt.func_82582_d() ? null : originalNbt.func_74737_b();
            int hashCode1 = 31 + Boolean.hashCode(isEmpty);
            hashCode1 = 31 * hashCode1 + item.hashCode();
            hashCode1 = 31 * hashCode1 + (nbt == null ? 0 : nbt.hashCode());
            this.hashCode = hashCode1 = 31 * hashCode1 + template.func_77952_i();
        }

        public void setStack(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStack getStack() {
            return this.itemStack;
        }

        public boolean equals(Object o) {
            return API.instance().getComparer().isEqualNoQuantity(this.itemStack, ((ItemStackWrapper)o).itemStack);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

